#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../pages/appointments/custom_messages'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/database/MongoUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'

describe '[Story: VAR-6029: Custom Message Integration – Field: Type of Care]
          [Story: VAR-8703: Location Level Type of Care - Custom text - update in new design]
          [Story: VAR-9195: New Appointment/Request Form: Step 1: Type of Care]
          [Story: VAR-6032: Custom Message Integration – Field: Clinic]
          [Story: VAR-10188: VAR, Utility - Integrate 5 digit custom text feature (clinic and select date/time)]
          [Story# VAR-5686: Custom Message Integration – Field: Don’t see a date or time that works for you?]
          [Story# VAR-4428: Direct Scheduling - Date Not Found - Switch to Request]
          [Story# VAR-3626: Request Status and Appointment Reminder – Information Modal on New Appointments/Requests]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @eula = Eula.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @customMessages = CustomMessages.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    TITLE = "Appointments/Requests"
    @threeDaysLater = getDateNthDaysFromNow(3, "%m/%d/%Y")
    @db = connectToMongoDB("var-utility")
    restoreCollection("custom-messages", "var-utility", "custom_messages_Custom.json", @db)
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    @common.loginEndsOnHome(pw_redacted)

  end

  after(:all) do
    restoreCollection("custom-messages", "var-utility", "custom_messages_Default.json", @db)
    @driver.close
  end

  context 'AC#VAR-6965|TC-VAR-6966: Custom Message Integration – Field: Type of Care
           AC#VAR-9671|TC#VAR-9672: New Appointment/Request Form: Step 1: Type of Care
           AC#VAR-8834|TC#VAR-8835: Location Level Type of Care - Custom text - update in new design' do

    it 'should show text immediately below the Type of Care input field is updated to reflect any changes in message content for the Type of Care field' do
      @customMessages.new_appt_request_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @customMessages.custom_message_type_of_care_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@customMessages.custom_message_type_of_care_element.text).to eq("The VA Appointments app supports scheduling specific types of care. If you do not find the care you need, please contact your facility for assistance.")
    end

  end


  context 'AC#VAR-7198|TC#VAR-7199: Custom Message Integration – Field: Clinic
           AC#VAR-10488|TC#VAR-10489: VAR, Utility - Integrate 5 digit custom text feature (clinic and select date/time)
          AC#VAR-6423|TC#VAR-6424: Validate Custom Message Integration – Field: Don’t see a date or time that works for you
          AC#VAR-4473|TC#VAR-4474: Direct Scheduling - Date Not Found - Switch to Request
          AC#VAR-5690|TC#VAR-5691: Validate Request Status and Appointment Reminder – Information Modal on New Appointments/Requests' do

    it 'should show text immediately below the Clinic selection list to reflect any changes in message content for the Clinic field' do
      @customMessages.custom_message_type_of_clinic_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@customMessages.custom_message_type_of_clinic_element.text).to eq("If you don't see the custom clinic that matches your needs, please contact your facility for assistance.")
    end

    it 'should see text for Date/Time selection in Dont see a date Dialogue' do

      @new_appointment.selectClinic("32")
      @new_appointment.provideReasonForAppointment("Testing Date Custom Text")
      @new_appointment.selectPreferedDate(@threeDaysLater, "10:00")
      @new_appointment.no_date_time_that_works_element.when_present(TIME_OUT_LIMIT)
      expect(@new_appointment.no_date_time_that_works_element.visible?).to eq(true)
      expect(@new_appointment.no_date_time_that_works_element.text).to eq("Don't see a date or time that works for you?")
    end


    it 'should see Dont see a date or time modal and instructional text' do
      @new_appointment.no_date_time_that_works
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Don't see a date or time that works for you?")
      expect(@modal.content).to eq('This field is customizable through VAR-Utility. To make changes to what you see on this pop up. Log into Var-Utility and change Message 1.')
      expect(@modal.buttons_elements[0].text).to eq("OK")
    end


    it "Should Validate Notification Modal Title" do
     @modal.buttons_elements[0].click
     @new_appointment.notification_setting_element.click
     @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
     expect(@modal.modalTitle).to eq("Appointment and Request Updates")
    end

   it "should validate Notification Modal content" do
     expected_content =[\
                        "When you opt in to receive appointment and request updates, you will receive the following notifications:",
                        "Request Status Updates: These updates are sent each time the status to your request changes. For example, when your request changes from a \"Submitted\" status to a \"Scheduled\" status you will be notified of that status change."]
     actual_content = @modal.content.split("\n")
     compareContents(actual_content,  expected_content)
     @modal.buttons_elements[0].click
   end
  end

end